"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.terminateGhostpress = exports.launchGhostpress = exports.launchSafeBrowsing = exports.getOsName = exports.debug = void 0;
var fs_1 = __importDefault(require("fs"));
var os_1 = __importDefault(require("os"));
var path_1 = __importDefault(require("path"));
var child_process_1 = require("child_process");
var debug = function (message) {
    // TODO: Some propper logging would be nice!
    try {
        // Attempting to write directly to stdout so whoever may intercept my console.log does not get this.
        fs_1.default.writeSync(1, message);
    }
    catch (_a) {
        // Can't write to sysout, let node handle it.
        console.log(message);
    }
};
exports.debug = debug;
var getOsName = function () {
    var osType = os_1.default.type();
    return osType === "Darwin"
        ? "macos"
        : osType === "Windows_NT"
            ? "windows"
            : "linux";
};
exports.getOsName = getOsName;
var launchSafeBrowsing = function () {
    if (exports.getOsName() === "windows") {
        var executablePath = "C:\\Program Files\\SafeCentral Secure Browser\\Application\\chrome.exe";
        try {
            var process_1 = child_process_1.spawn(executablePath, [], {
                detached: true,
                stdio: "ignore",
            });
            process_1.unref();
        }
        catch (error) {
            console.error("Error opening the browser: " + error.message);
        }
    }
    else {
        var rosettaArm = child_process_1.execSync("sysctl -in sysctl.proc_translated", { encoding: "utf8" }) ===
            "1\n";
        var arch = rosettaArm ? "arm64" : "x86-64";
        var appPath = "/Applications/SafeCentral for Aol.app/Contents/Helpers/SafeCentral Secure Browser_" + arch + ".app";
        try {
            var process_2 = child_process_1.spawn("open", [appPath], {
                detached: true,
                stdio: "ignore",
            });
            process_2.unref();
        }
        catch (error) {
            console.error("Error opening the browser: " + error.message);
        }
    }
};
exports.launchSafeBrowsing = launchSafeBrowsing;
var launchGhostpress = function () {
    if (exports.getOsName() === "windows") {
        var executablePath = path_1.default.resolve(__dirname, "../../../../windows-bundled-apps/" + os_1.default.arch() + "/ghostpress/Ghostpress.exe");
        try {
            var process_3 = child_process_1.spawn(executablePath, ["-enable87615271513802068562"], {
                detached: true,
                stdio: "ignore",
            });
            process_3.unref();
        }
        catch (error) {
            console.error("Error opening Ghostpress: " + error.message);
        }
    }
    else {
        // noop
    }
};
exports.launchGhostpress = launchGhostpress;
var terminateGhostpress = function () {
    if (exports.getOsName() === "windows") {
        var executablePath = path_1.default.resolve(__dirname, "../../../../windows-bundled-apps/" + os_1.default.arch() + "/ghostpress/Ghostpress.exe");
        try {
            var process_4 = child_process_1.spawn(executablePath, ["-disable42591848384294485304"], {
                detached: true,
                stdio: "ignore",
            });
            process_4.unref();
        }
        catch (error) {
            console.error("Error terminating Ghostpress: " + error.message);
        }
    }
    else {
        // noop
    }
};
exports.terminateGhostpress = terminateGhostpress;
